//Global var
var CRUMINA = {};

(function ($) {

    // USE STRICT
    "use strict";

    //----------------------------------------------------/
    // Predefined Variables
    //----------------------------------------------------/
    var $window = $(window),
        $document = $(document),
        $body = $('body'),

        swipers = {},
        //Elements
        $header = $('#site-header'),
        $topbar = $header.siblings('.top-bar'),
        $nav = $('#primary-menu'),
        $header_space = $header.next('.header-spacer'),
        $counter = $('.counter'),
        $progress_bar = $('.skills-item'),
        $pie_chart = $('.pie-chart'),
        $animatedIcons = $('.js-animate-icon'),
        $asidePanel = $('.right-menu'),
        $primaryMenu = $('.primary-menu'),
        $subscribe_section = $('#subscribe-section'),
        $footer = $('#site-footer');


    var $popupSearch = $(".popup-search");
    var $cartPopap = $(".cart-popup-wrap");


    /* -----------------------
     * Fixed Header
     * --------------------- */



    CRUMINA.fixedHeader = function () {
        $header.headroom(
            {
                "offset": 50,
                "tolerance": 5,
                "classes": {
                    "initial": "animated",
                    "pinned": $header.data('pinned'),
                    "unpinned": $header.data('unpinned'),
                },
                onUnpin: function () {
                    if ($nav.find('.sub-menu, .megamenu').hasClass('drop-up')) {
                        this.elem.classList.remove(this.classes.unpinned);
                        this.elem.classList.add(this.classes.pinned);
                    }
                    else {
                        this.elem.classList.add(this.classes.unpinned);
                        this.elem.classList.remove(this.classes.pinned);
                    }
                }
            }
        )
    };

    /* -----------------------
     * Parallax footer
     * --------------------- */

    CRUMINA.parallaxFooter = function () {
        if ($footer.length && $footer.hasClass('js-fixed-footer')) {
            $footer.before('<div class="block-footer-height"></div>');
            $('.block-footer-height').matchHeight({
                target: $footer
            });
        }
    };

    /* -----------------------
     * COUNTER NUMBERS
     * --------------------- */
    CRUMINA.counters = function () {
        if ($counter.length) {
            $counter.each(function () {
                $(this).waypoint(function () {
                    var $current = $(this.element).find('span'),
                        $count = $current.data('to');
                    if (!$current.hasClass('animated')) {
                        $current.countup($count);
                        $current.addClass('animated');
                    }

                }, {offset: '95%'});
            });
        }
    };
    /* -----------------------
     * Progress bars Animation
     * --------------------- */
    CRUMINA.progresBars = function () {
        if ($progress_bar.length) {
            $progress_bar.each(function () {
                $(this).find('.skills-item-meter-active').addClass('item-fully-transparent');
                $(this).waypoint(function () {
                    var $current = $(this.element).find('.count-animate'),
                        $count = $current.data('to');
                    if ( ! $current.hasClass('animated') ) {
                        $current.countup($count);
                        $current.addClass('animated');
                    }
                    $(this.element).find('.skills-item-meter-active').fadeTo(300, 1).addClass('skills-animate').removeClass('item-fully-transparent');
                }, {offset: '90%'});
            });
        }
    };

    /* -----------------------
     * Pie chart Animation
     * --------------------- */
    CRUMINA.pieCharts = function () {
        if ($pie_chart.length) {
            $pie_chart.each(function () {
               // $(this).waypoint(function () {
                    var current_cart = $(this);
                    var startColor = current_cart.data('startcolor');
                    var endColor = current_cart.data('endcolor');
                    var counter = current_cart.data('value') * 100;

                    current_cart.circleProgress({
                        thickness: 16,
                        size: 320,
                        startAngle: -Math.PI / 4 * 2,
                        emptyFill: '#fff',
                        lineCap: 'round',
                        fill: {
                            gradient: [endColor,startColor],
                            gradientAngle: Math.PI / 4
                        }
                    }).on('circle-animation-progress', function (event, progress) {
                        current_cart.find('.content').html(parseInt(counter * progress, 10) + '<span>%</span>'
                        )
                    });
                   // this.destroy();

                //}, {offset: '90%'});
            });
        }
    };
    /* -----------------------
     * Animate SVG Icons
     * --------------------- */
    CRUMINA.animateSvg = function () {
        if ($animatedIcons.length) {
            $animatedIcons.each(function () {
                $(this).waypoint(function () {
                    var mySVG = $(this.element).find('> svg').drawsvg();
                    mySVG.drawsvg('animate');
                   // this.destroy();
                }, {offset: '95%'});
            });
        }
    };
    /* -----------------------
     * Tooltips JS plugin Init
     * --------------------- */
    CRUMINA.tooltips = function () {
        new Tippy('.tippy', {
            animation: 'scale',
            arrow: true
        })
    };
    /* -----------------------
     * Run Chart js module
     * --------------------- */
    CRUMINA.chartJs = function () {
        $('.chart-js-run').each(function () {
            $(this).waypoint(function () {
                var $wrapper = $(this.element);
                var el_id = $wrapper.data('id');
                var dataholder = $wrapper.find('.chart-data');
                var ctx = document.getElementById(el_id);
                var myChart = new Chart(ctx, {
                    type: $wrapper.data('type'),
                    data: {
                        labels: dataholder.data('labels'),
                        datasets: [
                            {
                                data: dataholder.data('numbers'),
                                backgroundColor: dataholder.data('colors')
                            }]
                    },
                    options: {
                        legend: {
                            display: false
                        }
                    },
                    animation: {
                        animateScale: true
                    }
                });
                this.destroy();
            }, {offset: '75%'});
        });
    };

    CRUMINA.runchartJS = function ( $wrapper ) {
        var el_id = $wrapper.data('id');
        var dataholder = $wrapper.find('.chart-data');
        var ctx = document.getElementById(el_id);
        var myChart = new Chart(ctx, {
            type: $wrapper.data('type'),
            data: {
                labels: dataholder.data('labels'),
                datasets: [
                    {
                        data: dataholder.data('numbers'),
                        backgroundColor: dataholder.data('colors')
                    }]
            },
            options: {
                legend: {
                    display: false
                }
            },
            animation: {
                animateScale: true
            }
        });
    };
    CRUMINA.runTimeLine = function () {
        $('.cd-horizontal-timeline').each(function () {
            $(this).horizontalTimeline();
        });
    };
    /* -----------------------------
     * Custom Scroll bar
     * ---------------------------*/
    CRUMINA.customScroll = function () {
        if ($asidePanel.length) {
            $asidePanel.mCustomScrollbar({
                axis: "y",
                scrollEasing: "linear",
                scrollInertia: 150
            });
        }
    };




    $("#top-bar-language").on('change', function () {
        var lang_href = jQuery(jQuery(this).children('[value=' + $(this).val() + ']')).data('url');
        if (lang_href) {
            document.location.href = lang_href;
        }
    });

    /* -----------------------------
     * Toggle aside panel on click
     * ---------------------------*/
    CRUMINA.togglePanel = function () {
        if ($asidePanel.length) {
            $asidePanel.toggleClass('opened');
            $body.toggleClass('overlay-enable');
        }
    };
    /* -----------------------------
     * Toggle Top bar on click
     * ---------------------------*/
    CRUMINA.toggleBar = function () {
            $topbar.toggleClass('open');
            $body.toggleClass('overlay-enable');
            return false;
    };
    /* -----------------------------
     * Toggle search overlay
     * ---------------------------*/
    CRUMINA.toggleSearch = function () {
        $body.toggleClass('open');
        $('.overlay_search-input').focus();
    };
    /* -----------------------------
     * Embedded Video in pop up
     * ---------------------------*/
    CRUMINA.mediaPopups = function () {
        $('.js-popup-iframe').magnificPopup({
            disableOn: 700,
            type: 'iframe',
            mainClass: 'mfp-fade',
            removalDelay: 160,
            preloader: false,

            fixedContentPos: false
        });
        $('.js-zoom-image, .link-image').magnificPopup({
            type: 'image',
            removalDelay: 500, //delay removal by X to allow out-animation
            callbacks: {
                beforeOpen: function () {
                    // just a hack that adds mfp-anim class to markup
                    this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
                    this.st.mainClass = 'mfp-zoom-in';
                }
            },
            closeOnContentClick: true,
            midClick: true
        });
        $('.js-zoom-gallery').each(function () {
            $(this).magnificPopup({
                delegate: 'a[data-lightbox="gallery-item"]',
                type: 'image',
                gallery: {
                    enabled: true
                },
                removalDelay: 500, //delay removal by X to allow out-animation
                callbacks: {
                    beforeOpen: function () {
                        // just a hack that adds mfp-anim class to markup
                        this.st.image.markup = this.st.image.markup.replace('mfp-figure', 'mfp-figure mfp-with-anim');
                        this.st.mainClass = 'mfp-zoom-in';
                    }
                },
                closeOnContentClick: true,
                midClick: true
            });
        });

        $('.js-open-video').magnificPopup({
            type: 'inline',
            mainClass: 'inline--media-content overlay active animation-wrapper', // this class is for CSS animation below
            zoom: {
                enabled: true, // By default it's false, so don't forget to enable it
                duration: 300, // duration of the effect, in milliseconds
                easing: 'ease-in-out' // CSS transition easing function
            },
            callbacks: {
                open: function () {
                    var player = plyr.setup('.plyr-module');
                },
                close: function () {
                    var player = plyr.get('.plyr-module');
                    player[0].destroy();
                }
            }
        });
    };
    /* -----------------------------
     * Equal height
     * ---------------------------*/
    CRUMINA.equalHeight = function () {
        $('.js-equal-child').find('.theme-module').matchHeight({
            property: 'min-height'
        });
    };

    /* -----------------------------
     * Scrollmagic scenes animation
     * ---------------------------*/
    CRUMINA.SubscribeScrollAnnimation = function () {
        var controller = new ScrollMagic.Controller();
        new ScrollMagic.Scene({triggerElement: "#subscribe-section"})
            .setVelocity(".gear", {opacity: 1, rotateZ: "360deg"}, 1200)
            .triggerHook("onEnter")
            .addTo(controller);

        new ScrollMagic.Scene({triggerElement: "#subscribe-section"})
            .setVelocity(".mail", {opacity: 1, bottom: "0"}, 600)
            .triggerHook(0.8)
            .addTo(controller);

        new ScrollMagic.Scene({triggerElement: "#subscribe-section"})
            .setVelocity(".mail-2", {opacity: 1, right: "20"}, 800)
            .triggerHook(0.9)
            .addTo(controller);
    };

    CRUMINA.SeoScoreScrollAnnimation = function () {
        var controller = new ScrollMagic.Controller();

        new ScrollMagic.Scene({triggerElement: ".crumina-seo-score"})
            .setVelocity(".crumina-seo-score .seoscore1", {opacity: 1, top: "-10"}, 400)
            .triggerHook("onEnter")
            .addTo(controller);

        new ScrollMagic.Scene({triggerElement: ".crumina-seo-score"})
            .setVelocity(".crumina-seo-score .seoscore2", {opacity: 1, bottom: "0"}, 800)
            .triggerHook(0.7)
            .addTo(controller);

        new ScrollMagic.Scene({triggerElement: ".crumina-seo-score"})
            .setVelocity(".crumina-seo-score .seoscore3", {opacity: 1, bottom: "0"}, 1000)
            .triggerHook(0.8)
            .addTo(controller);
    };

    CRUMINA.TestimonialScrollAnnimation = function () {
        var controller = new ScrollMagic.Controller();

        new ScrollMagic.Scene({triggerElement: ".crumina-testimonial-slider"})
            .setVelocity(".crumina-testimonial-slider .testimonial2", {opacity: 1, bottom: "-50"}, 400)
            .triggerHook(0.6)
            .addTo(controller);

        new ScrollMagic.Scene({triggerElement: ".crumina-testimonial-slider"})
            .setVelocity(".crumina-testimonial-slider .testimonial1", {opacity: 1, top: "20"}, 600)
            .triggerHook(1)
            .addTo(controller);
    };

    CRUMINA.OurVisionScrollAnnimation = function () {
        var controller = new ScrollMagic.Controller();

        new ScrollMagic.Scene({triggerElement: ".crumina-our-vision"})
            .setVelocity(".crumina-our-vision .elements", {opacity: 1}, 600)
            .triggerHook(0.6)
            .addTo(controller);

        new ScrollMagic.Scene({triggerElement: ".crumina-our-vision"})
            .setVelocity(".crumina-our-vision .eye", {opacity: 1, bottom: "-90"}, 1000)
            .triggerHook(1)
            .addTo(controller);
    };

    CRUMINA.MountainsScrollAnnimation = function () {
        var controller = new ScrollMagic.Controller();

        new ScrollMagic.Scene({triggerElement: ".crumina-background-mountains"})
            .setVelocity(".crumina-background-mountains .mountain1", {
                opacity: 1,
                bottom: "0",
                paddingBottom: "10%"
            }, 800)
            .triggerHook(0.4)
            .addTo(controller);

        new ScrollMagic.Scene({triggerElement: ".crumina-background-mountains"})
            .setVelocity(".crumina-background-mountains .mountain2", {opacity: 1, bottom: "0"}, 800)
            .triggerHook(0.3)
            .addTo(controller);
    };
    /* -----------------------------
     * Isotope sorting
     * ---------------------------*/

    CRUMINA.IsotopeSort = function () {
        var $container = $('.sorting-container');
        $container.each(function () {
            var $current = $(this);
            var layout = ($current.data('layout').length) ? $current.data('layout') : 'masonry';
            $current.isotope({
                itemSelector: '.sorting-item',
                layoutMode: layout,
                percentPosition: true
            });

            $current.imagesLoaded().progress(function () {
                $current.isotope('layout');
            });

            var $sorting_buttons = $current.siblings('.sorting-menu').find('li');

            $sorting_buttons.each(function () {
                var selector = $(this).data('filter');
                var count = $container.find(selector).length;
                if (count === 0) {
                    $(this).css('display', 'none');
                }
            });
            if ($sorting_buttons.filter(':visible').length < 2 ){
                $container.siblings('.sorting-menu').hide();
            }

            $sorting_buttons.on('click', function () {
                if ($(this).hasClass('active')) return false;
                $(this).parent().find('.active').removeClass('active');
                $(this).addClass('active');
                var filterValue = $(this).data('filter');
                if (typeof filterValue != "undefined") {
                    $current.isotope({filter: filterValue});
                    return false;
                }
            });
        });
    };

    /* -----------------------------
     * Sliders and Carousels
     * ---------------------------*/

    CRUMINA.initSwiper = function () {
        var initIterator = 0;
        var $breakPoints = false;
        $('.swiper-container').each(function () {

            var $t = $(this);
            var index = 'swiper-unique-id-' + initIterator;

            $t.addClass('swiper-' + index + ' initialized').attr('id', index);
            $t.find('.swiper-pagination').addClass('pagination-' + index);

            var $effect = ($t.data('effect')) ? $t.data('effect') : 'slide',
                $crossfade = ($t.data('crossfade')) ? $t.data('crossfade') : true,
                $loop = ($t.data('loop') === false) ? $t.data('loop') : true,
                $showItems = ($t.data('show-items')) ? $t.data('show-items') : 1,
                $scrollItems = ($t.data('scroll-items')) ? $t.data('scroll-items') : 1,
                $scrollDirection = ($t.data('direction')) ? $t.data('direction') : 'horizontal',
                $mouseScroll = ($t.data('mouse-scroll')) ? $t.data('mouse-scroll') : false,
                $parallax = ($t.data('parallax')) ? $t.data('parallax') : false,
                $autoplay = ($t.data('autoplay')) ? parseInt($t.data('autoplay'), 10) : 0,
                $slidesSpace = ($showItems > 1) ? 20 : 0;

            if ($showItems > 1) {
                $breakPoints = {
                    480: {
                        slidesPerView: 1,
                        slidesPerGroup: 1
                    },
                    768: {
                        slidesPerView: 2,
                        slidesPerGroup: 2
                    }
                }
            } else {
                $breakPoints = {
                    768: {
                        slidesPerView: 1,
                        slidesPerGroup: 1
                    }
                }
            }

            swipers['swiper-' + index] = new Swiper('.swiper-' + index, {
                pagination: '.pagination-' + index,
                paginationClickable: true,
                direction: $scrollDirection,
                mousewheelControl: $mouseScroll,
                mousewheelReleaseOnEdges: $mouseScroll,
                slidesPerView: $showItems,
                slidesPerGroup: $scrollItems,
                spaceBetween: $slidesSpace,
                keyboardControl: true,
                preloadImages: true,
                updateOnImagesReady: true,
                autoplay: $autoplay,
                autoplayDisableOnInteraction:false,
                loop: $loop,
                breakpoints: $breakPoints,
                effect: $effect,
                fade: {
                    crossFade: true
                },
                parallax: $parallax,
                calculateHeight: true,
                onImagesReady: function (swiper) {
                    CRUMINA.resizeSwiper(swiper);
                },
                onTransitionStart: function (swiper) {
                    CRUMINA.resizeSwiper(swiper);
                },
                onSlideChangeStart: function (swiper) {
                    if ($t.find('.slider-slides').length) {
                        $t.find('.slider-slides .slide-active').removeClass('slide-active');
                        var realIndex = swiper.slides.eq(swiper.activeIndex).attr('data-swiper-slide-index');
                        $t.find('.slider-slides .slides-item').eq(realIndex).addClass('slide-active');
                    }
                }

            });
            initIterator++;
        });

        //swiper arrows
        $('.btn-prev').on('click', function () {
            var mySwiper = swipers['swiper-' + $(this).parent().attr('id')];
            mySwiper.slidePrev();
        });

        $('.btn-next').on('click', function () {
            var mySwiper = swipers['swiper-' + $(this).parent().attr('id')];
            mySwiper.slideNext();
        });

        //swiper tabs
        $('.slider-slides .slides-item').on('click', function () {
            if ($(this).hasClass('slide-active')) return false;
            var mySwiper = swipers['swiper-' + $(this).closest('.swiper-container').attr('id')];
            var activeIndex = $(this).parent().find('.slides-item').index(this);
            var $loop = (mySwiper.container.data('loop') === false) ? mySwiper.container.data('loop') : true;
            if (true === $loop) {
                activeIndex = activeIndex + 1;
            }
            mySwiper.slideTo(activeIndex);
            $(this).parent().find('.slide-active').removeClass('slide-active');
            $(this).addClass('slide-active');
            mySwiper.update();
            return false;

        });
    };

    CRUMINA.resizeSwiper = function (swiper) {
        swiper = (swiper) ? swiper : $(this)[0].swiper;

        var activeSlideHeight = swiper.slides.eq(swiper.activeIndex).find('> *').outerHeight();

        if ($(swiper.container).hasClass('pagination-vertical')){
            var headlineHeights = swiper.slides.map(function() {
                return $(this).find('> *').height();
            }).get();

            var maxHeadLineHeight = Math.max.apply(Math, headlineHeights);
            swiper.container.css({height: maxHeadLineHeight + 'px'});
            swiper.update(true)
        }

        if ($(swiper.container).hasClass('auto-height')){
            swiper = (swiper) ? swiper : $(this)[0].swiper;
            swiper.container.css({height: activeSlideHeight + 'px'});
            swiper.onResize();
        }

        $('.swiper-container.js-full-window').each(function () {
            var $slider = $(this);
            var $pagination = $slider.find(' > .slider-slides'),
                $pagination_height = ($pagination.length) ? $pagination.height() : 0;

            var winHei = $(window).height();
            $slider.css('min-height', winHei + 'px');
            if ($pagination_height > 0) {
                $slider.css('paddingBottom', $pagination_height + 'px')
            }
            if ($header_space.length) {
                var $heder_height = $header_space.height();
            } else {
                $heder_height = 0;
            }
            $slider.css('min-height', winHei - $heder_height + 'px');
            $slider.find('> .swiper-wrapper').css('min-height', winHei - $pagination_height - $heder_height + 'px');
        });
    };


    CRUMINA.initSmoothScroll = function () {

        // Cut the mustard
        var supports = 'querySelector' in document && 'addEventListener' in window;
        if (!supports) return;

        // Get all Toggle selectors
        var anchors = $('#primary-menu a[href*=\\#], .btn[href*=\\#]').filter(function () {
            return $(this).is(":not([href=\\#])");
        });

        // Add smooth scroll to all anchors
        for (var i = 0, len = anchors.length; i < len; i++) {
            var url = new RegExp(window.location.hostname + window.location.pathname);
            if (!url.test(anchors[i].href)) continue;
            anchors[i].setAttribute('data-scroll', true);
        }

        if ( window.location.hash ) {
            var anchor = document.querySelector( window.location.hash ); // Get the anchor
            var toggle = document.querySelector( 'a[href*="' + window.location.hash + '"]' ); // Get the toggle (if one exists)
            var options = {}; // Any custom options you want to use would go here
            smoothScroll.animateScroll( anchor, toggle, options );
        }

        smoothScroll.init({
            selector: '[data-scroll]',
            speed: 500, // Integer. How fast to complete the scroll in milliseconds
            easing: 'easeOutQuad', // Easing pattern to use
            offset: $header.height(),
            updateURL: true, // Boolean. If true, update the URL hash on scroll
            callback: function (anchor, toggle) {
            } // Function to run after scrolling
        });

        $('#primary-menu').find('[href=\\#]').on('click',function () {
            return false
        })

    };

    CRUMINA.initVideo = function () {
        plyr.setup('.plyr');
    };

    CRUMINA.burgerAnimation = function () {
        /* In animations (to close icon) */

        var beginAC = 80,
            endAC = 320,
            beginB = 80,
            endB = 320;

        function inAC(s) {
            s.draw('80% - 240', '80%', 0.3, {
                delay: 0.1,
                callback: function () {
                    inAC2(s)
                }
            });
        }

        function inAC2(s) {
            s.draw('100% - 545', '100% - 305', 0.6, {
                easing: ease.ease('elastic-out', 1, 0.3)
            });
        }

        function inB(s) {
            s.draw(beginB - 60, endB + 60, 0.1, {
                callback: function () {
                    inB2(s)
                }
            });
        }

        function inB2(s) {
            s.draw(beginB + 120, endB - 120, 0.3, {
                easing: ease.ease('bounce-out', 1, 0.3)
            });
        }

        /* Out animations (to burger icon) */

        function outAC(s) {
            s.draw('90% - 240', '90%', 0.1, {
                easing: ease.ease('elastic-in', 1, 0.3),
                callback: function () {
                    outAC2(s)
                }
            });
        }

        function outAC2(s) {
            s.draw('20% - 240', '20%', 0.3, {
                callback: function () {
                    outAC3(s)
                }
            });
        }

        function outAC3(s) {
            s.draw(beginAC, endAC, 0.7, {
                easing: ease.ease('elastic-out', 1, 0.3)
            });
        }

        function outB(s) {
            s.draw(beginB, endB, 0.7, {
                delay: 0.1,
                easing: ease.ease('elastic-out', 2, 0.4)
            });
        }

        /* Scale functions */

        function addScale(m) {
            m.className = 'menu-icon-wrapper scaled';
        }

        function removeScale(m) {
            m.className = 'menu-icon-wrapper';
        }

        /* Awesome burger scaled */

        var pathD = document.getElementById('pathD'),
            pathE = document.getElementById('pathE'),
            pathF = document.getElementById('pathF'),
            segmentD = new Segment(pathD, beginAC, endAC),
            segmentE = new Segment(pathE, beginB, endB),
            segmentF = new Segment(pathF, beginAC, endAC),
            wrapper2 = document.getElementById('menu-icon-wrapper'),
            trigger2 = document.getElementById('menu-icon-trigger'),
            toCloseIcon2 = true;

        wrapper2.style.visibility = 'visible';

        trigger2.onclick = function () {
            addScale(wrapper2);
            if (toCloseIcon2) {
                inAC(segmentD);
                inB(segmentE);
                inAC(segmentF);
            } else {
                outAC(segmentD);
                outB(segmentE);
                outAC(segmentF);

            }
            toCloseIcon2 = !toCloseIcon2;
            setTimeout(function () {
                removeScale(wrapper2)
            }, 450);
        };
    };


    /* -----------------------------
     * On Click Functions
     * ---------------------------*/


    $window.keydown(function (eventObject) {
        if (eventObject.which == 27) {
            if ($asidePanel.hasClass('opened')) {
                CRUMINA.togglePanel();
            }
            if ($body.hasClass('open')) {
                CRUMINA.toggleSearch();
            }
            if ($topbar.hasClass('open')) {
                CRUMINA.toggleBar();
            }
        }
    });

    jQuery(".js-close-aside").on('click', function () {
        if ($asidePanel.hasClass('opened')) {
            CRUMINA.togglePanel();
        }
        return false;
    });

    jQuery(".js-open-aside").on('click', function () {
        if (!$asidePanel.hasClass('opened')) {
            CRUMINA.togglePanel();
        }
        return false;
    });

    //top bar
    $(".top-bar-link").on('click', function () {
        $topbar.toggleClass('open');
        $body.toggleClass('overlay-enable');
    });
    $('.top-bar-close').on('click', function () {
        CRUMINA.toggleBar();
    });



    jQuery(".js-open-search").on('click', function () {
        CRUMINA.toggleSearch();
        return false;
    });

    jQuery(".overlay_search-close").on('click', function () {
        $body.removeClass('open');
        return false;
    });

    jQuery(".js-open-p-search").on('click', function () {
        $popupSearch.fadeToggle();
    });

    if ($popupSearch.length) {
        $popupSearch.find('input').focus(function () {
            $popupSearch.stop().animate({
                'width': $popupSearch.closest('.container').width() + 70
            }, 600)
        }).blur(function () {
            $popupSearch.fadeToggle('fast', function () {
                $popupSearch.css({
                    'width': ''
                });
            });

        });
    }

    // Hide cart on click outside.
    $document.on('click', function (event) {
        if (!$(event.target).closest($cartPopap).length) {
            if ($cartPopap.hasClass('visible')) {
                $cartPopap.fadeToggle(200);
                $cartPopap.toggleClass('visible')
            }
        }
        if (!$(event.target).closest($asidePanel).length) {
            if ($asidePanel.hasClass('opened')) {
                CRUMINA.togglePanel();
            }
        }

    });

    // Show sub-menu cart on icon click.
    $(".js-cart-animate").on('click', function (event) {
        event.stopPropagation();
        $cartPopap.toggleClass('visible');
        $cartPopap.fadeToggle(200);
    });

    //Remove play button on play in video player
    $('.plyr').on('click', function () {
        $(this).removeClass('hide-controls');
    });


    CRUMINA.quantity_selector_button_mod = function(){
        jQuery(".quantity input[type=number]").each(function() {
            var number = jQuery(this),
                max = parseFloat( number.attr( 'max' ) ),
                min = parseFloat( number.attr( 'min' ) ),
                step = parseInt( number.attr( 'step' ), 10 ),
                newNum = jQuery(jQuery('<div />').append(number.clone(true)).html().replace('number','text')).insertAfter(number);
            number.remove();

            setTimeout(function(){
                if(newNum.next('.quantity-plus').length == 0) {
                    var minus = jQuery('<input type="button" value="-" class="quantity-minus">').insertBefore(newNum),
                        plus    = jQuery('<input type="button" value="+" class="quantity-plus">').insertAfter(newNum);

                    minus.on('click', function(){
                        var the_val = parseInt( newNum.val(), 10 ) - step;
                        the_val = the_val < 0 ? 0 : the_val;
                        the_val = the_val < min ? min : the_val;
                        newNum.val(the_val);
                        enable_update_cart_button();
                    });
                    plus.on('click', function(){
                        var the_val = parseInt( newNum.val(), 10 ) + step;
                        the_val = the_val > max ? max : the_val;
                        newNum.val(the_val);
                        enable_update_cart_button();
                    });

                }
            },10);

        });
    };
    // since woocommerce 2.6 the update_cart button is disabeld by default and needs to be enabled if quantities change
    function enable_update_cart_button(){
        var $update_cart_button = jQuery( 'table.shop_table.cart' ).closest( 'form' ).find( 'input[name="update_cart"]' );
        if ( $update_cart_button.length ) {
            $update_cart_button.prop( 'disabled', false );
        }
    }
    // listen to updated_wc_div event since woocommerce 2.6 to redraw quantity selector and update the cart icon value
    jQuery( document ).bind( "updated_wc_div", function() {
        //setTimeout( update_cart_sub-menu, 1000 ); // high timeout needed because the minicard is drawn after the updated_wc_div event
        CRUMINA.quantity_selector_button_mod();
    });

    /*---------------------------------
     Ajax Form Submit
     -----------------------------------*/
    if ($('.fw_form_fw_form').length) {
        fwForm.initAjaxSubmit({
            selector: 'form[data-fw-ext-forms-type="contact-forms"]'

            // Open the script code and check the `opts` variable
            // to see all options that you can overwrite/customize.
        });
    }


    /*---------------------------------
     ACCORDION
     -----------------------------------*/
    $('.accordion-heading').on('click', function () {
        $(this).parents('.panel-heading').toggleClass('active');
        $(this).parents('.accordion-panel').toggleClass('active');
    });
    CRUMINA.initAccordion = function (wrp) {
        $(wrp).find('.accordion-heading')
            .off('click')
            .on('click', function () {
                $(this).parents('.panel-heading').toggleClass('active');
                $(this).parents('.accordion-panel').toggleClass('active');
            });
    };

    //Scroll to top.
    $('.back-to-top').on('click', function () {
        $('html,body').animate({
            scrollTop: 0
        }, 1200);
        return false;
    });

    $(".input-dark").find('input').focus(function () {
        $(this).closest('form').addClass('input-drop-shadow');
    }).blur(function () {
        $(this).closest('form').removeClass('input-drop-shadow');
    });

    /* -----------------------------
     * On DOM ready functions
     * ---------------------------*/

    $document.ready(function () {

        $(".input-text").each(function () {
           $(this).addClass('input-standard-grey');
        });
        $(".crumina-module.list").each(function () {
            var $this = $(this);
            var $icon  = $(this).data('icon');
            if ($icon.length){
                $this.find('li').wrapInner('<div class="ovh"></div>');
                $this.find('li').prepend('<i class="'+$icon+'"></i>');
            }
        });

        if ($('#menu-icon-wrapper').length) {
            CRUMINA.burgerAnimation();
        }
        // 3-d party libs run
        $primaryMenu.crumegamenu({
            showSpeed: 300,
            hideSpeed: 200,
            trigger: "hover",
            animation: "drop-up",
            indicatorFirstLevel: "&#xf0d7",
            indicatorSecondLevel: "&#xf105"
        });
        if (! $header.hasClass('disable-sticky')){
            if ($window.width() > 769){
                CRUMINA.fixedHeader();
            }
        }


        if ($('.tippy').length) {
            CRUMINA.tooltips();
        }

        //dom modifcation
        $('.nice-select').niceSelect();

        CRUMINA.initSwiper();
        CRUMINA.equalHeight();
        CRUMINA.customScroll();
        CRUMINA.mediaPopups();
        CRUMINA.IsotopeSort();
        CRUMINA.parallaxFooter();
        CRUMINA.runTimeLine();
        CRUMINA.initSmoothScroll();
        CRUMINA.quantity_selector_button_mod();

        // On Scroll animations.
        CRUMINA.animateSvg();
        CRUMINA.counters();
        CRUMINA.progresBars();
        CRUMINA.pieCharts();
        CRUMINA.chartJs();


        // Dom mofifications
        $('select.orderby, .variations select, .card-expiration select').niceSelect();
        //$('select#billing_country, select#card_state').select2();

        // Row background animation
        if ($subscribe_section.length && $subscribe_section.hasClass('js-animated')) {
            CRUMINA.SubscribeScrollAnnimation();
        }
        if ($('.crumina-seo-score').length) {
            CRUMINA.SeoScoreScrollAnnimation();
        }
        if ($('.crumina-testimonial-slider').length) {
            CRUMINA.TestimonialScrollAnnimation();
        }
        if ($('.crumina-our-vision').length) {
            CRUMINA.OurVisionScrollAnnimation();
        }
        if ($('.crumina-background-mountains').length) {
            CRUMINA.MountainsScrollAnnimation();
        }
    });

    $(window).on('resize',function(){
        if ( $window.width() > 769 ){
            CRUMINA.fixedHeader();
            $header.removeClass('headroom--not-bottom');
        } else {
            $header.headroom("destroy");
        }
    })
})(jQuery);